/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

class sCommandHandler
extends CommandHandler
implements NetworkConstants {
    private static final String PING = "/bin/ping";
    private static final String PING6 = "/usr/sbin/ping6";
    private static final String PING_OPT_TIMEOUT = "-w";
    private static final String PING_COUNT = "-c 1";
    private static final String PING_OPT_SRC = "-I";

    sCommandHandler() {
    }

    @Override
    protected VerificationCommand genReachCmd(String srcNode, String destNode) {
        String[] arg = new String[2];
        String[] env = null;
        String pingCmd = PING;
        try {
            if (VerificationUtil.isIPV6Host(destNode)) {
                pingCmd = PING6;
            }
        }
        catch (CVUException cvuEx) {
            Trace.out((String)("CVUException occured while determining " + destNode + " is a ipv6 host. mesg:" + cvuEx.getMessage()));
        }
        arg[0] = "-runexe";
        arg[1] = " " + pingCmd + " " + destNode + " " + PING_COUNT + " " + PING_OPT_TIMEOUT + String.valueOf(sCommandHandler.getTimeOut());
        return new VerificationCommand(srcNode, arg, env);
    }

    @Override
    protected VerificationCommand genIPConCmd(String srcNode, String srcIP, String destIP) {
        String[] arg = new String[2];
        String[] env = null;
        arg[0] = "-runexe";
        arg[1] = " /bin/ping " + destIP + " " + PING_COUNT + " " + PING_OPT_TIMEOUT + " " + String.valueOf(sCommandHandler.getTimeOut()) + " " + PING_OPT_SRC + " " + srcIP;
        return new VerificationCommand(srcNode, arg, env);
    }

    @Override
    protected VerificationCommand genIPConCmd(String srcNode, String srcIP, String destIP, int family) {
        String[] arg = new String[2];
        String[] env = null;
        arg[0] = "-runexe";
        if (family == 4) {
            arg[1] = " /bin/ping " + destIP + " " + PING_COUNT + " " + PING_OPT_TIMEOUT + " " + String.valueOf(sCommandHandler.getTimeOut()) + " " + PING_OPT_SRC + " " + srcIP;
        } else {
            if (srcIP.startsWith("fe80")) {
                srcIP = srcIP.substring(srcIP.lastIndexOf(37) + 1);
            }
            arg[1] = " /usr/sbin/ping6 " + destIP + " " + PING_COUNT + " " + PING_OPT_TIMEOUT + " " + String.valueOf(sCommandHandler.getTimeOut()) + " " + PING_OPT_SRC + " " + srcIP;
        }
        return new VerificationCommand(srcNode, arg, env);
    }

    @Override
    protected boolean parseConCmd(VerificationCommand vfyCmd) {
        boolean expectedExitCode = false;
        boolean succ = true;
        if (0 != vfyCmd.getVfyCode()) {
            succ = false;
            Trace.out((String)("vfyCmd returned: " + vfyCmd.getVfyCode()));
            Trace.out((String)("vfyCmd output: " + vfyCmd.getOutput()));
        }
        return succ;
    }

    private static int getTimeOut() {
        return 3;
    }
}

